' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion. 
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports Microsoft.VisualBasic
Imports System.Data
Imports System.Data.Common

Public Class BlogManagerDB

  ''' <summary>
  ''' Ukryj konstruktor, aby unikn tworzenia egzemplarzy klasy BlogManagerDB.
  ''' </summary>
  Private Sub New()
  End Sub

  ''' <summary>
  ''' Zwraca ostanich 15 (lub mniej, jeli nie ma tylu) wpisw w blogu z bazy danych.
  ''' </summary>
  ''' <returns>DataSet z wpisami w blogu.</returns>
  Public Shared Function GetBlogEntries() As DataSet
    Dim myDataSet As DataSet = New DataSet()

    Dim myFactory As DbProviderFactory = DbProviderFactories.GetFactory(AppConfiguration.ConnectionStringSettings.ProviderName)
    Using myConnection As DbConnection = myFactory.CreateConnection()
      myConnection.ConnectionString = AppConfiguration.ConnectionStringSettings.ConnectionString
      myConnection.Open()

      Dim myCommand As DbCommand = myConnection.CreateCommand()

      myCommand.CommandText = "sprocBlogEntrySelectList"
      myCommand.CommandType = CommandType.StoredProcedure

      Dim myDataAdapter As DbDataAdapter = myFactory.CreateDataAdapter()
      myDataAdapter.SelectCommand = myCommand
      myDataAdapter.Fill(myDataSet)
      myConnection.Close()
      Return myDataSet
    End Using

  End Function

  ''' <summary>
  ''' Zwraca wpisy w blogu opublikowane w okrelonej kategorii.
  ''' </summary>
  ''' <param name="categoryId">Identyfikator kategorii w bazie danych, dla ktrej wpisy w blogu ma by zwrcone.</param>
  ''' <returns>DataSet z wpisami w blogu.</returns>
  Public Shared Function GetBlogEntries(ByVal categoryId As Integer) As DataSet
    Dim myDataSet As DataSet = New DataSet()

    Dim myFactory As DbProviderFactory = DbProviderFactories.GetFactory(AppConfiguration.ConnectionStringSettings.ProviderName)
    Using myConnection As DbConnection = myFactory.CreateConnection()
      myConnection.ConnectionString = AppConfiguration.ConnectionStringSettings.ConnectionString
      myConnection.Open()

      Dim myCommand As DbCommand = myConnection.CreateCommand()

      myCommand.CommandText = "sprocBlogEntrySelectListByCategory"
      myCommand.CommandType = CommandType.StoredProcedure

      Dim param As DbParameter
      param = myCommand.CreateParameter()
      param.ParameterName = DalHelpers.ReturnCommandParamName("categoryId")
      param.DbType = DbType.Int32
      param.Value = categoryId
      myCommand.Parameters.Add(param)

      Dim myDataAdapter As DbDataAdapter = myFactory.CreateDataAdapter()
      myDataAdapter.SelectCommand = myCommand
      myDataAdapter.Fill(myDataSet)
      myConnection.Close()
      Return myDataSet
    End Using

  End Function

  ''' <summary>
  ''' Zwraca wpisy w blogu opublikowane w okrelonym przedziale czasu.
  ''' </summary>
  ''' <param name="startDate">Pocztkowa data przedziau czasu, z ktrego wpisy w blogu maj by zwrcone.</param>
  ''' <param name="endDate">Kocowa data przedziau czasu, z ktrego wpisy w blogu maj by zwrcone.</param>
  ''' <returns>DataSet z wpisami w blogu.</returns>
  Public Shared Function GetBlogEntries(ByVal startDate As DateTime, ByVal endDate As DateTime) As DataSet
    Dim myDataSet As DataSet = New DataSet()

    Dim myFactory As DbProviderFactory = DbProviderFactories.GetFactory(AppConfiguration.ConnectionStringSettings.ProviderName)
    Using myConnection As DbConnection = myFactory.CreateConnection()
      myConnection.ConnectionString = AppConfiguration.ConnectionStringSettings.ConnectionString
      myConnection.Open()

      Dim myCommand As DbCommand = myConnection.CreateCommand()

      myCommand.CommandText = "sprocBlogEntrySelectListByDate"
      myCommand.CommandType = CommandType.StoredProcedure

      Dim param As DbParameter

      param = myCommand.CreateParameter()
      param.ParameterName = DalHelpers.ReturnCommandParamName("startDate")
      param.DbType = DbType.DateTime
      param.Value = startDate
      myCommand.Parameters.Add(param)

      param = myCommand.CreateParameter()
      param.ParameterName = DalHelpers.ReturnCommandParamName("endDate")
      param.DbType = DbType.DateTime
      ' zapytanie uywa endDate z klauzul BETWEEN wic dodajemy 1 do endDate, aby uwgledni take endDate
      param.Value = endDate.AddDays(1)
      myCommand.Parameters.Add(param)

      Dim myDataAdapter As DbDataAdapter = myFactory.CreateDataAdapter()
      myDataAdapter.SelectCommand = myCommand
      myDataAdapter.Fill(myDataSet)
      myConnection.Close()
      Return myDataSet
    End Using
  End Function

  ''' <summary>
  ''' Zwraca pojedynczy obiekt BlogEntry z bazy danych na podstawie jego identyfikatora.
  ''' </summary>
  ''' <param name="blogEntryId">Identyfikator wpisu w bazie danych.</param>
  ''' <returns>Egzemplarz klasy BlogEntry, jeli znaleziono pozycj lub <see langword="Nothing" /> w przeciwnym razie.</returns>
  Public Shared Function GetBlogEntry(ByVal blogEntryId As Integer) As BlogEntry
    Dim myBlogEntry As BlogEntry = Nothing
    Dim myFactory As DbProviderFactory = DbProviderFactories.GetFactory(AppConfiguration.ConnectionStringSettings.ProviderName)

    Using myConnection As DbConnection = myFactory.CreateConnection()
      myConnection.ConnectionString = AppConfiguration.ConnectionStringSettings.ConnectionString

      Dim myCommand As DbCommand = myConnection.CreateCommand()

      myCommand.CommandText = "sprocBlogEntrySelectSingleItem"
      myCommand.CommandType = CommandType.StoredProcedure

      Dim param As DbParameter
      param = myCommand.CreateParameter()
      param.ParameterName = DalHelpers.ReturnCommandParamName("Id")
      param.DbType = DbType.Int32
      param.Value = blogEntryId
      myCommand.Parameters.Add(param)

      myConnection.Open()

      Using myReader As DbDataReader = _
          myCommand.ExecuteReader(CommandBehavior.CloseConnection)
        If myReader.Read() Then
          myBlogEntry = New BlogEntry(myReader.GetInt32(myReader.GetOrdinal("Id")))
          myBlogEntry.Title = myReader.GetString(myReader.GetOrdinal("Title"))
          myBlogEntry.Body = myReader.GetString(myReader.GetOrdinal("Body"))
          myBlogEntry.CategoryId = myReader.GetInt32(myReader.GetOrdinal("CategoryId"))
          myBlogEntry.DatePublished = myReader.GetDateTime(myReader.GetOrdinal("DatePublished"))
        End If
        myReader.Close()
      End Using
    End Using
    Return myBlogEntry
  End Function

  ''' <summary>
  ''' Zapisuje wpis z bloga w bazie danych.
  ''' </summary>
  ''' <param name="myBlogEntry">Obiekt BlogEntry do zapisania.</param>
  Public Shared Sub SaveBlogEntry(ByVal myBlogEntry As BlogEntry)

    Dim myFactory As DbProviderFactory = DbProviderFactories.GetFactory(AppConfiguration.ConnectionStringSettings.ProviderName)
    Using myConnection As DbConnection = myFactory.CreateConnection()

      myConnection.ConnectionString = AppConfiguration.ConnectionStringSettings.ConnectionString
      myConnection.Open()

      Dim myCommand As DbCommand = myConnection.CreateCommand()

      If myBlogEntry.Id = -1 Then ' Wstaw nowy wpis
        myCommand.CommandText = "sprocBlogEntryInsertSingleItem"
      Else ' zmie istniejcy wpis
        myCommand.CommandText = "sprocBlogEntryUpdateSingleItem"
      End If

      myCommand.CommandType = CommandType.StoredProcedure

      Dim param As DbParameter

      param = myCommand.CreateParameter()
      param.ParameterName = DalHelpers.ReturnCommandParamName("title")
      param.DbType = DbType.String
      param.Value = myBlogEntry.Title
      myCommand.Parameters.Add(param)

      param = myCommand.CreateParameter()
      param.ParameterName = DalHelpers.ReturnCommandParamName("body")
      param.DbType = DbType.String
      param.Value = myBlogEntry.Body
      myCommand.Parameters.Add(param)

      param = myCommand.CreateParameter()
      param.ParameterName = DalHelpers.ReturnCommandParamName("categoryId")
      param.DbType = DbType.Int32
      param.Value = myBlogEntry.CategoryId
      myCommand.Parameters.Add(param)

      param = myCommand.CreateParameter()
      param.ParameterName = DalHelpers.ReturnCommandParamName("datePublished")
      param.DbType = DbType.DateTime
      param.Value = myBlogEntry.DatePublished.AddHours(DateTime.Now.Hour).AddMinutes(DateTime.Now.Minute)
      myCommand.Parameters.Add(param)

      If myBlogEntry.Id <> -1 Then ' aktualizuje istniejcy wpis, wic musimy przesa identyfikator
        param = myCommand.CreateParameter()
        param.ParameterName = DalHelpers.ReturnCommandParamName("id")
        param.DbType = DbType.Int32
        param.Value = myBlogEntry.Id
        myCommand.Parameters.Add(param)
      End If

      myCommand.ExecuteNonQuery()

    End Using

  End Sub

  ''' <summary>
  ''' Pobiera list dostpnych kategorii z bazy danych.
  ''' </summary>
  Public Shared Function GetCategories() As DataSet
    Dim myDataSet As DataSet = New DataSet()

    Dim myFactory As DbProviderFactory = DbProviderFactories.GetFactory(AppConfiguration.ConnectionStringSettings.ProviderName)
    Using myConnection As DbConnection = myFactory.CreateConnection()
      myConnection.ConnectionString = AppConfiguration.ConnectionStringSettings.ConnectionString
      myConnection.Open()

      Dim myCommand As DbCommand = myConnection.CreateCommand()

      myCommand.CommandText = "sprocCategorySelectList"
      myCommand.CommandType = CommandType.StoredProcedure

      Dim myDataAdapter As DbDataAdapter = myFactory.CreateDataAdapter()
      myDataAdapter.SelectCommand = myCommand
      myDataAdapter.Fill(myDataSet)
      myConnection.Close()
      Return myDataSet
    End Using
  End Function

End Class
